<?php

/**
 * HmsModel
 */
class HmsModel
{
      public static function encryptColumn($table,$column)
      {
        /*$database = DatabaseFactory::getFactory()->getConnection();
        $sql = "ALTER TABLE ".$table." ADD b_".$column." BLOB NOT NULL";
        $query = $database->prepare($sql);
        $query->execute();*/

        $database = DatabaseFactory::getFactory()->getConnection();
        $sql = "SELECT id,".$column." FROM ".$table;
        $query = $database->prepare($sql);
        //$parameters = array(':column' => $column,':table' => $table);
        $query->execute();
        $results=$query->fetchAll(PDO::FETCH_ASSOC);
        foreach($results as $result){
           $encrypted=Encryption::encrypt($result[$column]);
           $sql="UPDATE ".$table." SET b_".$column."=:encrypted WHERE id=".$result['id'];
           $parameters = array(':encrypted' => $encrypted);
           $query = $database->prepare($sql);
           $query->execute($parameters);
        }
        print_r($results);
        exit();
      }

    /**
     * Get all vehicle classes
     * parameters none
     * returns array
     */
    public static function getAllVehicleClasses()
    {
        $database = DatabaseFactory::getFactory()->getConnection();

        $data=array();
        $sql="SELECT id,vehicleClass FROM vehicleclass ORDER BY id";
        $query = $database->prepare($sql);
        $query->execute();
        $classes=$query->fetchAll(PDO::FETCH_ASSOC);
        foreach($classes as $class){
           $id=$class['id'];
           $sql = "SELECT id,name FROM vehicle WHERE vehicleClass=:id ORDER BY id";
           $query = $database->prepare($sql);
           $parameters = array(':id' => $id);
           $query->execute($parameters);
           $vehicles=$query->fetchAll(PDO::FETCH_ASSOC);
           $data[]=array("class"=>$class['vehicleClass'],"vehicles"=>$vehicles);
        }
        $sql="SELECT id,name FROM vehicle WHERE vehicleClass=-1 ORDER BY id";
        $query = $database->prepare($sql);
        $query->execute();
        $toplevelvehicles=$query->fetchAll(PDO::FETCH_ASSOC);
        foreach($toplevelvehicles as $toplevelvehicle){
           $data[]=array("class"=>"","vehicles"=>array("id"=>$toplevelvehicle['id'],"name"=>$toplevelvehicle['name']));
        }
        return $data;
    }

    /**
     * Get get view by type
     * parameters vehicleid(int),type(string),view(string),version(int)
     * returns JSON
     */
    public static function getViewByType($vehicleid,$type,$view,$version)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $results="";
       $sql="SELECT version,name,image,b_poddata FROM view WHERE name=:view AND vehicleid=:vehicleid AND scheduleid='1' AND version=:version";
       $query = $database->prepare($sql);
       $parameters = array(':view'=>$view,':vehicleid' => $vehicleid,':version'=>$version);
       $query->execute($parameters);
       while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
          $pods=json_decode(Encryption::decrypt($row['b_poddata']),true);
          $podarray=array();
          foreach ($pods as $pod){
             $poddata="";
             $poddata.='{"top":'.$pod['top'].',"left":'.$pod['left'].',"ptop":'.$pod['ptop'].',"pleft":'.$pod['pleft'].',"common":';
             $poddata.=json_encode($pod['common']);
             $poddata.=',"'.$type.'":'.json_encode($pod[$type]).'}';
             $podarray[]=$poddata;
          }
          $results='{"version":'.$row['version'].',"name":"'.$row['name'].'","image":"'.$row['image'].'","pods":['.join(',',$podarray).']}';
       }

       if($results=="")$results='{"name":"'.$view.'","image":"img/configuration/blank.jpg","pods":[]}';
       return $results;
    }

    /**
     * Get a list of general repair schemes for a given vehicle
     * parameters vehicleid(int)
     * returns array
     */
    public static function getRepairSchemeList($vehicleid)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $results=array();
       $sql="SELECT * FROM repairschemes WHERE vehicleid=:vehicleid AND type='general'";
       $query = $database->prepare($sql);
       $parameters=array(':vehicleid' => $vehicleid);
       $query->execute($parameters);
       while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
          $results[]=array('id'=>$row['id'],'reference'=>$row['reference'],'title'=>$row['title']);
       }
       return $results;
    }

    /**
     * Get a list of specific repair schemes for a given vehicle
     * parameters vehicleid(int)
     * returns array
     */
    public static function getSpecificRepairSchemeList($vehicleid)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $vrns=array();
       $sql="SELECT DISTINCT(vrn) as 'vrns' FROM repairschemes WHERE vehicleid=:vehicleid AND type='specific'";
       $query = $database->prepare($sql);
       $parameters=array(':vehicleid' => $vehicleid);
       $query->execute($parameters);
       $vrns=$query->fetchAll(PDO::FETCH_ASSOC);
       $results=array();
       $sql="SELECT * FROM repairschemes WHERE vehicleid=:vehicleid AND type='specific'";
       $query = $database->prepare($sql);
       $parameters=array(':vehicleid' => $vehicleid);
       $query->execute($parameters);
       while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
          $results[]=array('id'=>$row['id'],'reference'=>$row['reference'],'vrn'=>$row['vrn'],'title'=>$row['title']);
       }
       return array('vrns'=>$vrns,'schemes'=>$results);
    }

    /**
     * Get a list of specific repair schemes for a given vehicle and vrn
     * parameters vehicleid(int),vrn(string)
     * returns array
     */
    public static function getSpecificRepairByVRN($vehicleid,$vrn)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $results=array();
       $filter=($vrn=='all')?'vrn!=:vrn':'vrn=:vrn';
       $sql="SELECT * FROM repairschemes WHERE vehicleid=:vehicleid AND type='specific' AND ".$filter;
       $query = $database->prepare($sql);
       $parameters=array(':vehicleid' => $vehicleid,':vrn' => $vrn);
       $query->execute($parameters);
       while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
          $results[]=array('id'=>$row['id'],'reference'=>$row['reference'],'description'=>$row['description'],'vrn'=>$row['vrn'],'title'=>$row['title']);
       }
       return $results;
    }

    /**
     * Get a list of inspection versions and their statuses for a given vehicle
     * parameters vehicleid(int)
     * returns array
     */
    public static function getInspectionVersions($vehicleid)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $sql="SELECT version,status FROM inspectionversion WHERE status>1 AND vehicleid=:vehicleid ORDER BY version DESC";
       $query = $database->prepare($sql);
       $parameters = array(':vehicleid' => $vehicleid);
       $query->execute($parameters);
       return $query->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Get a list of inspection intervals for a given vehicle
     * parameters vehicleid(int)
     * returns array
     */
    public static function getInspectionIntervals($vehicleid)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $sql="SELECT id,value FROM inspectioninterval WHERE vehicleid=:vehicleid ORDER BY roworder";
       $query = $database->prepare($sql);
       $parameters = array(':vehicleid' => $vehicleid);
       $query->execute($parameters);
       return $query->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Get a list of holding units for a given vehicle
     * parameters vehicleid(int)
     * returns array
     */
    public static function getHoldingUnits($vehicleid)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $sql="SELECT value FROM holdingUnit WHERE vehicleid=:vehicleid ORDER BY roworder";
       $query = $database->prepare($sql);
       $parameters = array(':vehicleid' => $vehicleid);
       $query->execute($parameters);
       return $query->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Get a list of vehicle statuses for a given vehicle
     * parameters vehicleid(int)
     * returns array
     */
    public static function getVehicleStatuses($vehicleid)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $sql="SELECT value,roworder FROM status WHERE vehicleid=:vehicleid ORDER BY roworder";
       $query = $database->prepare($sql);
       $parameters = array(':vehicleid' => $vehicleid);
       $query->execute($parameters);
       return $query->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Get inspection results based on the given filters
     * parameters vehicleid(int),version(int),vrn(string),date(int),interval(int),unit(string),status(int),completed(int)
     * returns array
     */
    public static function getInspectionResults($vehicleid,$version,$vrn,$date,$interval,$unit,$status,$completed)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $iscomplete=array("1=1"," completed=100 "," completed<100 ");
       $realdate=date('Y-m-d',strtotime("-".$date." months"));
       $parameters = array(':vehicleid' => $vehicleid);
       $search=array();
       $order=" ORDER BY id;";
       $searchcriteria="SELECT id,version,vrn,date,scheduleid,unit,status,completed,score FROM inspection WHERE";
       $search[]=" vehicleid=:vehicleid ";
       if($version!=""){
           $search[]=" version=:version ";
           $parameters[':version']=$version;
       }
       if($vrn!=""){
           $search[]= " vrn=:vrn ";
           $parameters[':vrn']=$vrn;
       }
       if($date!=""){
           $search[]= " date>:realdate ";
           $parameters[':realdate']=$realdate;
       }
       if($interval!=""){
           $search[]= " scheduleid=:interval ";
           $parameters[':interval']=$interval;
       }
       if($unit!=""){
           $search[]= " unit=:unit ";
           $parameters[':unit']=$unit;
       }
       if($status!=""){
           $search[]= " status=:status ";
           $parameters[':status']=$status;
       }
       if($completed!=""){
           $search[]= $iscomplete[$completed];
       }
       $searchcriteria.=join(" AND ",$search);        
       $searchcriteria.=$order;

       $query = $database->prepare($searchcriteria);
       $query->execute($parameters);
       return $query->fetchAll(PDO::FETCH_ASSOC);

    }

    /**
     * Get a map of inspection intervals for a given vehicle
     * parameters vehicleid(int)
     * returns array
     */
    public static function getInspectionIntervalsMap($vehicleid)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $data=array();
       $sql="SELECT id,value FROM inspectioninterval WHERE vehicleid=:vehicleid ORDER BY roworder";
       $query = $database->prepare($sql);
       $parameters = array(':vehicleid' => $vehicleid);
       $query->execute($parameters);
       $intervals=$query->fetchAll(PDO::FETCH_ASSOC);
       foreach($intervals as $interval){
           $data[$interval['id']]=$interval['value'];
       }
       return $data;
    }

    /**
     * Get condition results based on the given filters
     * parameters vehicleid(int),version(int),vrn(string),unit(string),status(int),score(int),scoretype(string)
     * returns array
     */
    public static function getConditionResults($vehicleid,$vrn,$unit,$status,$score,$scoretype)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $parameters = array(':vehicleid' => $vehicleid);
       $search=array();
       $order=" ORDER BY id;";
       $searchcriteria="SELECT * FROM vehiclecondition WHERE";
       $search[]=" vehicleid=:vehicleid ";
       if($vrn!=""){
           $search[]= " vrn=:vrn ";
           $parameters[':vrn']=$vrn;
       }
       if($unit!=""){
           $search[]= " unit=:unit ";
           $parameters[':unit']=$unit;
       }
       if($status!=""){
           $search[]= " status=:status ";
           $parameters[':status']=$status;
       }
       if($score!="")$order= " ORDER BY overallscore $scoretype LIMIT $score ";
       $searchcriteria.=join(" AND ",$search);        
       $searchcriteria.=$order;

       $query = $database->prepare($searchcriteria);
       //echo '<br><br><br>[ PDO DEBUG ]: ' . Helper::debugPDO($searchcriteria, $parameters);  exit();
       $query->execute($parameters);
       return $query->fetchAll(PDO::FETCH_ASSOC);

    }

    /**
     * Get reference material results based on the given filters
     * parameters vrn(string),vidno(string),general(string),year(string)
     * returns array
     */
    public static function getReferenceMaterialResults($vrn,$vidno,$general,$year)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $search=array();
       $parameters=array();
       $searchcriteria="SELECT * FROM referencematerial WHERE";
       $search[]=" 1=1 ";
       if($vrn!=""){
          $search[]= " vrn=:vrn ";
          $parameters[':vrn']=$vrn;
       }
       if($vidno!=""){
          $search[]=" vidno=:vidno ";
          $parameters[':vidno']=$vidno;
       }
       if($general!=""){
          //this is a temp fix - should not use post variables
          $search[]=" (documenttitle LIKE ('%".$general."%') OR reference LIKE ('%".$general."%') OR organisationname LIKE ('%".$general."%')) ";
          $parameters[':general']=$general;
       }
       if($year!=""){
          $search[]=" issuedate=:year ";
          $parameters[':year']=$year;
       }
       $searchcriteria.=join(" AND ",$search);
       $searchcriteria.=" ORDER BY id;";
       $query = $database->prepare($searchcriteria);
       $query->execute($parameters);
       return $query->fetchAll(PDO::FETCH_ASSOC);

    }

     /**
     * Get reference material record for given id
     * parameters id(int)
     * returns array
     */
    public static function getReferenceMaterialRecord($id)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $sql="SELECT * FROM referencematerial WHERE id=:id";
       $query = $database->prepare($sql);
       $parameters=array(':id' => $id);
       $query->execute($parameters);
       return $query->fetch(PDO::FETCH_ASSOC);

    }

    /**
     * Get vehicle info results based on the given vrn
     * parameters vrn(string)
     * returns array
     */
    public static function getVehicleInfoResults($vrn)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $search=array();
       $parameters=array();
       $searchcriteria="SELECT * FROM vehicleinfo WHERE";
       $search[]=" 1=1 ";
       if($vrn!="")$search[]= " vrn=:vrn ";
       $searchcriteria.=join(" AND ",$search);
       $searchcriteria.=" ORDER BY id;";
       $query = $database->prepare($searchcriteria);
       if(sizeof($search)>1)$parameters[':vrn']=$vrn;
       $query->execute($parameters);
       return $query->fetchAll(PDO::FETCH_ASSOC);

    }

     /**
     * Get vehicle info record for given id
     * parameters id(int)
     * returns array
     */
    public static function getVehicleInfoRecord($id)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $sql="SELECT * FROM vehicleinfo WHERE id=:id";
       $query = $database->prepare($sql);
       $parameters=array(':id' => $id);
       $query->execute($parameters);
       return $query->fetch(PDO::FETCH_ASSOC);

    }

    /**
     * Get minutes results based on the given filters
     * parameters general(string),year(string)
     * returns array
     */
    public static function getMinutesResults($general,$year)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $search=array();
       $parameters=array();
       $searchcriteria="SELECT * FROM minutes WHERE";
       $search[]=" 1=1 ";
       if($general!=""){
          $search[]=" (reporttitle LIKE ('%$general%') OR reference LIKE ('%$general%') OR organisation LIKE ('%$general%')) ";
          $parameters[':general']=$general;
       }
       if($year!=""){
          $search[]=" issuedate=:year ";
          $parameters[':year']=$year;
       }
       $searchcriteria.=join(" AND ",$search);
       $searchcriteria.=" ORDER BY id;";
       $query = $database->prepare($searchcriteria);
       $query->execute($parameters);
       return $query->fetchAll(PDO::FETCH_ASSOC);

    }

    /**
     * Get minutes record for given id
     * parameters id(int)
     * returns array
     */
    public static function getMinutesRecord($id)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $sql="SELECT * FROM minutes WHERE id=:id";
       $query = $database->prepare($sql);
       $parameters=array(':id' => $id);
       $query->execute($parameters);
       return $query->fetch(PDO::FETCH_ASSOC);

    }

    /**
     * Get all SSI records for given vehicle and inspection version
     * parameters vehicleid(int),latestinspectionversion(int)
     * returns array
     */
    private static function getAllSSIs($vehicleid,$latestinspectionversion)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $podids=array();
       $sql="SELECT poddata FROM view WHERE vehicleid=:vehicleid AND version=:latestinspectionversion AND scheduleid=1";
       $query = $database->prepare($sql);
       $query->execute(array(":vehicleid"=>$vehicleid,":latestinspectionversion"=>$latestinspectionversion));
       while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
          $pod=json_decode($row['poddata'],true);
          foreach($pod as $ssi){                     
             $podids[]=array('ref' => $ssi['common']['ref'],'title' => $ssi['common']['title'],'ssiid'=>$ssi['common']['ssiid'],'sj'=>$ssi['common']['SJ']);
          }
       }
       return $podids;

    }

    /**
     * Get all distinct vrns based on the given filters
     * parameters searchcriteria(string),parameters(array)
     * returns array
     */
    private static function getDistinctVRNs($searchcriteria,$parameters)
    {
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql="SELECT DISTINCT vrn AS 'distinctvrn' FROM inspection WHERE ".$searchcriteria;
        $query = $database->prepare($sql);
        $query->execute($parameters);
        return $query->fetchAll();

    }

    /**
     * Get the latest inspection version for a given vehicle
     * parameters vehicleid(int)
     * returns int
     */
    public static function getLatestInspectionVersion($vehicleid)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $sql="SELECT MAX(version) AS 'latestversion' FROM inspectionversion WHERE vehicleid=:vehicleid";
       $query = $database->prepare($sql);
       $parameters = array(':vehicleid' => $vehicleid);
       $query->execute($parameters);
       return $query->fetch()->latestversion;
    }

    /**
     * Get statistics results based on the given filters
     * parameters vehicleid(int),version(int),vrn(string),date(int),interval(int),unit(string),status(int),completed(int)
     * returns array
     */
    public static function getStatisticsResults($vehicleid,$version,$vrn,$date,$interval,$unit,$status,$completed)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $iscomplete=array("1=1"," completed=100 "," completed<100 ");
       $realdate=date('Y-m-d',strtotime("-".$date." months"));
       $parameters = array(':vehicleid' => $vehicleid);
       $search=array();
       $order=" ORDER BY id;";
       $searchcriteria="";
       $search[':vehicleid']=" vehicleid=:vehicleid ";
       if($version!=""){
           $search[':version']=" version=:version ";
           $parameters[':version']=$version;
       }
       if($vrn!=""){
           $search[':vrn']= " vrn=:vrn ";
           $parameters[':vrn']=$vrn;
       }
       if($date!=""){
           $search[':realdate']= " date>:realdate ";
           $parameters[':realdate']=$realdate;
       }
       if($interval!=""){
           $search[':interval']= " scheduleid=:interval ";
           $parameters[':interval']=$interval;
       }
       if($unit!=""){
           $search[':unit']= " unit=:unit ";
           $parameters[':unit']=$unit;
       }
       if($status!=""){
           $search[':status']= " status=:status ";
           $parameters[':status']=$status;
       }
       if($completed!=""){
           $search[]= $iscomplete[$completed];
       }
       $searchcriteria.=join(" AND ",$search);        
       $searchcriteria.=$order;
       $latestinspectionversion=self::getLatestInspectionVersion($vehicleid);
       //$latestinspectionversion=self::getLatestReleaseInspectionVersion($vehicleid);
       $podids=self::getAllSSIs($vehicleid,$latestinspectionversion);
       $jsonresults=array();
       $plotresults=array();

       foreach($podids as $podid){
          $all_vrn_list=array();
          $flawed_vrn_list=array();
          $sj=$podid['sj'];
          $max_flaw_size=($sj=="")?0:(int)$sj;
          $total_flaw_size=0;
          $average_flaw_size=0;
          $vrn_count=0;
          $flaw_count=1;
          $max_vehicle_flaw_sizes=array();
          $includerecord=false;
          $distinctvrns=self::getDistinctVRNs($searchcriteria,$parameters);
          foreach($distinctvrns as $distinctvrn){
            $inspectionpods="";
            $include=true;
            $max_vehicle_flaw_size=($sj=="")?0:(int)$sj;
            $_vrn=$distinctvrn->distinctvrn;
            $parameters[':vrn']=$_vrn;
            $searchcriteria2=join(" AND ",$search);
            //get all inspection records per vrn
            $sql="SELECT vrn,pods,b_pods,date FROM inspection WHERE ".$searchcriteria2." AND vrn=:vrn ORDER BY date";
            $query = $database->prepare($sql);
            $query->execute($parameters);
            $searchcriteria.=join(" AND ",$search);
            //print_r($parameters);
            //echo '<br><br>[ PDO DEBUG ]: ' . Helper::debugPDO($sql, $parameters);  exit();
            while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
                  if(!in_array($row['vrn'],$all_vrn_list)){
                      $all_vrn_list[]=$row['vrn'];
                  }
                  //$inpection_podarray=json_decode($row['pods'],true);
                  $inpection_podarray=json_decode(Encryption::decrypt($row['b_pods']),true);
                  foreach($inpection_podarray as $inspectionpod){
                     $ssiid=$inspectionpod['ssiid'];
                     if($ssiid==$podid['ssiid']){
                        $includerecord=true;
                        $flawsize=$inspectionpod['flawsize'];
                        //case if string (yes/no)
                        if($include&&!is_numeric($flawsize)){
                           $max_flaw_size='n/a';
                           $average_flaw_size='n/a';
                           if(strtolower($flawsize)=='yes'){
                               $flawed_vrn_list[]=$row['vrn'];
                               $include=false;
                           }
                           if(strtolower($flawsize)=='no'){
                               $include=true;
                           }
                        }
                        //case if integer
                        if(is_numeric($flawsize)){
                           if($sj==""){
                              if($include&&(int) $flawsize>0){
                                 $flawed_vrn_list[]=$row['vrn'];
                                 $include=false;
                              }
                              if((int) $flawsize==0){
                                 $include=true;
                              }
                              if((int) $flawsize>$max_flaw_size){
                                 $max_flaw_size=(int) $flawsize;
                              }
                              if((int) $flawsize>$max_vehicle_flaw_size){
                                 $max_vehicle_flaw_size=(int) $flawsize;
                              }
                           }
                           else{
                              if($include&&(int) $flawsize<(int)$sj){
                                 $flawed_vrn_list[]=$row['vrn'];
                                 $include=false;
                              }
                              if((int) $flawsize==(int)$sj){
                                 $include=true;
                              }
                              if((int) $flawsize<$max_flaw_size){
                                 $max_flaw_size=(int) $flawsize;
                              }
                              if((int) $flawsize<$max_vehicle_flaw_size){
                                 $max_vehicle_flaw_size=(int) $flawsize;
                              }
                           }
                        }
                     }
                  }
            }
            if($max_vehicle_flaw_size>0)$max_vehicle_flaw_sizes[]=$max_vehicle_flaw_size;
          }
          $reference=$podid['ref'];
          $title=$podid['title'];
          $ssiid=$podid['ssiid'];
          $count_of_all_vrns=count($all_vrn_list);
          $count_of_flawed_vrns=count($flawed_vrn_list);
          $distinct_flawed_vrn_list=array_unique($flawed_vrn_list);
          $count_of_distinct_flawed_vrns=count($distinct_flawed_vrn_list);
          $percentage_of_vrns_with_flaw=$count_of_all_vrns>0?($count_of_distinct_flawed_vrns/$count_of_all_vrns)*100:0;
          $average_flaw_size=is_numeric($average_flaw_size)&& count($max_vehicle_flaw_sizes)>0?array_sum($max_vehicle_flaw_sizes) / count($max_vehicle_flaw_sizes):$average_flaw_size;

          if($includerecord){
             $jsonresults[$ssiid]=array("ref"=>$reference,"title"=>$title,"location"=>$ssiid,"occurance"=>$count_of_flawed_vrns,"qty"=>$count_of_distinct_flawed_vrns."  (".round($percentage_of_vrns_with_flaw,2)."%)","max"=>$max_flaw_size,"average"=>round ( $average_flaw_size,2 ));
             $plotresults[$ssiid]=array("location"=>$ssiid,"occurrence"=>$count_of_flawed_vrns,"percentage"=>$percentage_of_vrns_with_flaw,"max"=>$max_flaw_size);
          }
       }
       $results=array('jsonresults'=>$jsonresults,'plotresults'=>$plotresults);
       return $results;
    }

    /**
     * Get scheduler results based on the given filters
     * parameters vehicleid(int),vrn(string),unit(string)
     * returns JSON string
     */
    public static function getSchedulerResults($vehicleid,$vrn,$unit,$inspectionDue="")
    {
       //echo '{"vehicleid":"'.$vehicleid.'","vrn":"'.$vrn.'","unit":"'.$unit.'"}';
       //exit;

       /*
       **This only works with warnings turned off - needs fixing
       */
       error_reporting(E_ERROR);
       $database = DatabaseFactory::getFactory()->getConnection();
       $now=date('m/d/Y');
       $realdate=date("m/d/Y",strtotime("+".$inspectionDue));
       $filter=array();
       $filter[]=" vehicleid=:vehicleid ";
       $parameters = array(':vehicleid' => $vehicleid);
       $titles=array();
       $vrns=array();

       $intervalmap=self::getInspectionIntervalsMap($vehicleid);

       /*
       **This should come from database ideally
       */
       $schedulemap=array();
       $schedulemap[1]="non-scheduled";
       $schedulemap[2]="non-scheduled";
       $schedulemap[3]="non-scheduled";
       $schedulemap[4]="non-scheduled";
       $schedulemap[5]="non-scheduled";
       $schedulemap[6]="non-scheduled";
       $schedulemap[7]="non-scheduled";
       $schedulemap[8]="non-scheduled";
       $schedulemap[9]="scheduled";
       $schedulemap[10]="scheduled";
       $schedulemap[11]="scheduled";
       $schedulemap[12]="scheduled";
       $schedulemap[13]="scheduled";
       $schedulemap[14]="non-scheduled";

       $scheduletime=array();
       $scheduletime[1]=0;
       $scheduletime[2]=0;
       $scheduletime[3]=0;
       $scheduletime[4]=0;
       $scheduletime[5]=0;
       $scheduletime[6]=0;
       $scheduletime[7]=0;
       $scheduletime[8]=0;
       $scheduletime[9]=6;
       $scheduletime[10]=12;
       $scheduletime[11]=500;
       $scheduletime[12]=3000;
       $scheduletime[13]=6000;
       $scheduletime[14]=0;

       if($unit!=""){
           $filter[]=" unit=:unit ";
           $parameters[':unit']=$unit;
           $titles[]=$unit;
       }
       if($vrn!=""){
           $filter[]=" vrn=:vrn ";
           $parameters[':vrn']=$vrn;
           $titles[]=$vrn;
       }
       $plottitle=join(" - ",$titles);
       $filterstring=join("AND",$filter);

       //get all SCHEDULED inspections using given filter
       $sql="SELECT * FROM inspection WHERE ".$filterstring." AND (scheduleid>8 AND scheduleid<14) ORDER BY date,id";
       $query = $database->prepare($sql);
       $query->execute($parameters);
       while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
          $vrns[$row['vrn']."_".$row['scheduleid']]['vrn']=$row['vrn'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['scheduleid']=$row['scheduleid'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['previousodometer']=$vrns[$row['vrn']."_".$row['scheduleid']]['odometer'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['previouspods']=$vrns[$row['vrn']."_".$row['scheduleid']]['pods'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['previousinspectiondate']=$vrns[$row['vrn']."_".$row['scheduleid']]['inspectiondate'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['inspectiondate']=$row['date'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['odometer']=$row['odometer'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['scheduletype']=$schedulemap[$row['scheduleid']];
          //$vrns[$row['vrn']."_".$row['scheduleid']]['pods']=self::decode_pod($row['pods']);
          $vrns[$row['vrn']."_".$row['scheduleid']]['pods']=self::decode_pod(Encryption::decrypt($row['b_pods']));
          $vrns[$row['vrn']."_".$row['scheduleid']]['inspectionversion']=$row['version'];
       }
       //calculate height of the plot window based on the number of discrete VRNS
       $plotheight=sizeof($vrns);
       $plotheight=$plotheight>0?($plotheight*150)+50:300;


       //create pod objects
       $dates=array();
       $scheduled_vrns=array();
       foreach($vrns as $_vrn){
          $scheduled_pods=array();
          $results=array();
          foreach($_vrn['pods'] as $pod){
             if($_vrn['previouspods']){
                foreach($_vrn['previouspods'] as $prev){
                   if($prev->ssiid==$pod->ssiid){
                      $pod->previousflawsize=$prev->flawsize;
                   }
                }
             }
             $pod->scheduleid=$_vrn['scheduleid'];
             $pod->inspectiondate=$_vrn['inspectiondate'];
             $pod->previousinspectiondate=$_vrn['previousinspectiondate'];
             $pod->odometer=$_vrn['odometer'];
             $pod->previousodometer=$_vrn['previousodometer'];
             $pod->scheduletype=$_vrn['scheduletype'];
             $reference=$pod->reference;
             //if there's a reference - fetch the associated RCM data
             if($reference){
               $rcmversion=self::getRCMVersion($vehicleid,$_vrn['inspectionversion']);
               $rcmdata=json_decode(self::getRCMData($rcmversion,$reference));
               $pod->rcm=$rcmdata;
             }
             $pod->calculate($scheduletime);
             //echo $pod->ssiid."=".$pod->previousinspectiondate."<br>";
             $scheduled_pods[$pod->ssiid]=array("ref"=>$pod->reference,"ssiid"=>$pod->ssiid,"date"=>date('m/d/Y',$pod->fd),"ghost"=>"");
             if(!$results[0])$results[0]=$pod->fa;
                 $results[0]=$results[0]>$pod->fa?$pod->fa:$results[0];
             if(!$results[1])$results[1]=$pod->fb;
                $results[1]=$results[1]>$pod->fb?$pod->fb:$results[1];
             if(!$results[2])$results[2]=$pod->fd;
                $results[2]=$results[2]>$pod->fd?$pod->fd:$results[2];
             if(!$results[3])$results[3]=$pod->fp;
                $results[3]=$results[3]>$pod->fp?$pod->fp:$results[3];
          }
          $dates[]=$results[3];
          $scheduled_vrns[$_vrn['vrn']][$_vrn['scheduleid']]=array("vrn"=>$_vrn['vrn'],"schedule"=>$_vrn['scheduleid'],"date1"=>$results[0],"date2"=>$results[1],"date3"=>$results[2],"date4"=>$results[3],"fp"=>$results[3],"pods"=>$scheduled_pods);
       }
       $vrns=array();
       //get all inspections using given filter
       $sql="SELECT * FROM inspection WHERE ".$filterstring." ORDER BY date,id";
       $query = $database->prepare($sql);
       $query->execute($parameters);
       while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
          $vrns[$row['vrn']."_".$row['scheduleid']]['vrn']=$row['vrn'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['scheduleid']=$row['scheduleid'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['previousodometer']=$vrns[$row['vrn']."_".$row['scheduleid']]['odometer'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['previouspods']=$vrns[$row['vrn']."_".$row['scheduleid']]['pods'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['previousinspectiondate']=$vrns[$row['vrn']."_".$row['scheduleid']]['inspectiondate'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['inspectiondate']=$row['date'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['odometer']=$row['odometer'];
          $vrns[$row['vrn']."_".$row['scheduleid']]['scheduletype']=$schedulemap[$row['scheduleid']];
          //$vrns[$row['vrn']."_".$row['scheduleid']]['pods']=self::decode_pod($row['pods']);
          $vrns[$row['vrn']."_".$row['scheduleid']]['pods']=self::decode_pod(Encryption::decrypt($row['b_pods']));
          $vrns[$row['vrn']."_".$row['scheduleid']]['inspectionversion']=$row['version'];
       }
       //create pod objects
       $all_vrns=array();
       foreach($vrns as $_vrn){
          $all_pods=array();
          foreach($_vrn['pods'] as $pod){
             if($_vrn['previouspods']){
                foreach($_vrn['previouspods'] as $prev){
                   if($prev->ssiid==$pod->ssiid){
                       $pod->previousflawsize=$prev->flawsize;
                   }
                }
             }

             $pod->scheduleid=$_vrn['scheduleid'];
             $pod->inspectiondate=$_vrn['inspectiondate'];
             $pod->previousinspectiondate=$_vrn['previousinspectiondate'];
             $pod->odometer=$_vrn['odometer'];
             $pod->previousodometer=$_vrn['previousodometer'];
             $pod->scheduletype=$_vrn['scheduletype'];
             $reference=$pod->reference;
             //if there's a reference - fetch the associated RCM data
             if($reference){
               $rcmversion=self::getRCMVersion($vehicleid,$_vrn['inspectionversion']);
               $rcmdata=json_decode(self::getRCMData($rcmversion,$reference));
               $pod->rcm=$rcmdata;
             }
             $pod->calculate($scheduletime);
             //echo $pod->ssiid."=".$pod->previousinspectiondate."<br>";
             //$all_pods[$pod->ssiid]=array("ref"=>$pod->reference,"ssiid"=>$pod->ssiid,"date"=>$pod->fd);
             $all_vrns[$_vrn['vrn']]['pods'][$pod->ssiid]=array("ref"=>$pod->reference,"ssiid"=>$pod->ssiid,"date"=>$pod->fd);
          }
          //$all_vrns[$_vrn['vrn']]=array("pods"=>$all_pods);
       }
       $finalvrns=array();
       $test=array();
       foreach($scheduled_vrns as $scheduled_vrn){
          foreach($scheduled_vrn as $scheduleid){
             $pods=array();
             $ghosts=array();
             foreach($scheduleid['pods'] as  $pod){
                $pods[]='{"ref":"'.$pod['ref'].'","ssiid":"'.$pod['ssiid'].'","date":"'.$pod['date'].'","ghost":"'.date('m/d/Y',$all_vrns[$scheduleid['vrn']]['pods'][$pod['ssiid']]['date']).'"}';
                $ghosts[]=$all_vrns[$scheduleid['vrn']]['pods'][$pod['ssiid']]['date'];
             }
             $date3=min($ghosts);
             $date4=$date3<$scheduleid['date2']?$date3:$scheduleid['date2'];
             $dates[]=$date4;
             $interval=$intervalmap[$scheduleid['schedule']];
             if(strlen($inspectionDue)>0){
               //echo strtotime($now)." ";//. strtotime($date4)>strtotime($now)&&strtotime($date4)<strtotime($realdate);
               if(date($date4)>strtotime($now)&&date($date4)<strtotime($realdate)){
                  $finalvrns[]='{"vrn":"'.$scheduleid['vrn'].'","schedule":"'.$interval.'","date1":"'.date('m/d/Y',$scheduleid['date1']).'","date2":"'.date('m/d/Y',$scheduleid['date2']).'","date3":"'.date('m/d/Y',$date3).'","date4":"'.date('m/d/Y',$date4).'","pods":['.join(',',$pods).']}';
               }
             }
             else{
                $finalvrns[]='{"vrn":"'.$scheduleid['vrn'].'","schedule":"'.$interval.'","date1":"'.date('m/d/Y',$scheduleid['date1']).'","date2":"'.date('m/d/Y',$scheduleid['date2']).'","date3":"'.date('m/d/Y',$date3).'","date4":"'.date('m/d/Y',$date4).'","pods":['.join(',',$pods).']}';
             }

          }
       }

       $vrnjson="[".join(",",$finalvrns)."]";
       $max=date('m/d/Y',max($dates));
       $min=date('m/d/Y',min($dates));
       $plotjson='{"plottitle":"'.$plottitle.'","plotheight":'.$plotheight.',"mindate":"'.$min.'","maxdate":"'.$max.'","data":'.$vrnjson.'}';
       return $plotjson;
    }

    /**
     * Get scheduler results based on the given filters
     * parameters vehicleid(int),vrn(string),unit(string)
     * returns JSON string
     */
    private static function decode_pod($json)
    {
       //require_once('pod.php');
       //change any single quotes to doubles
       $cleaned=str_replace("'",'"',$json);
       $str=$cleaned;
       //change any colons inside double quotes to asterix
       for ($i=$q=0,$res='' ; $i<strlen($str) ; $i++) {
          if ($str[$i] == '"') $q ^= 1;
          elseif ($q && ($str[$i]==':')) $str[$i]="*";
          $res .= $str[$i];
       }
       //decode into php associative array
       $pods=json_decode($res,true);
       //print_r($pods);
       //echo sizeof($pods);
       $result=array();
       if(is_array($pods)){
          foreach($pods as $pod){
             //$id=str_replace("*",":",$pod['id']);
             $id=$pod['ssiid'];
             //echo "id=".$id;
             $result[$id]=new Pod;
             $result[$id]->reference=$pod['ref'];
             $result[$id]->flawsize=$pod['flawsize'];
             $result[$id]->condemnationcriteria=$pod['condemnationcriteria'];
             $result[$id]->ssiid=$pod['ssiid'];

          }
       }
       //print_r($result);
       //exit();
       return $result;
    }

    /**
     * Get RCM version for an inspection version
     * parameters vehicleid(int),inspectionversion(int)
     * returns string
     */
    public static function getRCMVersion($vehicleid,$inspectionversion)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $sql="SELECT rcmversion FROM inspectionversion where vehicleid=:vehicleid AND version=:version";
       $query = $database->prepare($sql);
       $parameters = array(':vehicleid' => $vehicleid,':version'=>$inspectionversion);
       $query->execute($parameters);
       return $query->fetch()->rcmversion;
    }

    /**
     * Get RCM data
     * parameters version(int),reference(int)
     * returns string
     */
    public static function getRCMData($version,$reference)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $sql="SELECT data FROM rcm WHERE version=:version AND reference=:reference";
       $query = $database->prepare($sql);
       $parameters = array(':version' => $version,':reference'=>$reference);
       $query->execute($parameters);
       return $query->fetch()->data;
    }

    /**
     * Get available schedules for an inspection version
     * parameters vehicleid(int),version(int)
     * returns array
     */
    public static function getAvailableSchedules($vehicleid,$version)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $results=array();
       $sql="SELECT scheduleid, count(scheduleid) as total FROM view WHERE vehicleid=:vehicleid AND version=:version GROUP BY scheduleid ORDER BY total DESC";
       $query = $database->prepare($sql);
       $parameters = array(':vehicleid' => $vehicleid, ':version' => $version);
       $query->execute($parameters);
       while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
          if($row['total']==6){
             $id=$row['scheduleid'];
             $sql="SELECT value FROM inspectioninterval WHERE id=:id";
             $query2 = $database->prepare($sql);
             $parameters = array(':id' => $id);
             $query2->execute($parameters);
             while ($row2 = $query2->fetch(PDO::FETCH_ASSOC)) {
                $results[]=array("id" => $id,"value" => $row2['value']);
             }
          }
       }
       return $results;
    }

    /**
     * Get the latest inspection version for a given vehicle at pre-release or release
     * parameters vehicleid(int)
     * returns int
     */
    public static function getLatestReleaseInspectionVersion($vehicleid)
    {
       $database = DatabaseFactory::getFactory()->getConnection();

       $sql="SELECT MAX(version) AS 'latestrelease' FROM inspectionversion WHERE vehicleid=:vehicleid AND status>1";
       $query = $database->prepare($sql);
       $parameters = array(':vehicleid' => $vehicleid);
       $query->execute($parameters);
       return $query->fetch()->latestrelease;
    }


}